# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2004 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#
#
# @(#)82   1.35   src/csm/install/pkgdefs/Linux-SLES7.2.pm.perl, setup, csm_rameh, rameh0431a 7/6/04 06:30:51

#--------------------------------------------------------------------------------

=head3	Linux-SLES7.2.pm.perl

        Package Definition File:    SLES 7.2

        Notes:

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [ MgmtServer | MgdNode ]
                $::csm_version  = [ 1.3.0 | 1.3.1 | 1.3.2 | ... ]


        exceptions:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,
	otherwise the execption assignment will be overwriten by the default.

	OTHER DOCUMENTATION - see pkgdefs/Linux.pm

=cut

#--------------------------------------------------------------------------------

# houskeeping

package  SLES72;

do "/opt/csm/install/pkgdefs/Linux.pm";

NodeUtils->messageFromCat(
                          'csmInstall.cat',
                          $::MSGMAPPATH,
                          'csminstall',
                          'V',
                          'IMsgLoading',
                          "/opt/csm/install/pkgdefs/Linux-SLES7.2.pm"
                          );

my $_server_ = 'MgmtServer';
my $_node_   = 'MgdNode';

#--------------------------------------------------------------------------------

=head3	DISTRO Defintions

	Notes :

=cut

#--------------------------------------------------------------------------------
{

    $::pkgdefs{DISTRO_NAME}     = "SuSE SLES 7.2";
    $::pkgdefs{DISTRO_DISKLIST} = "1";               # TO BE REMOVED
    $::pkgdefs{DISTRO_RPMDIR}   = "full-names";

}

#--------------------------------------------------------------------------------

=head3  distro_disks - Distribution Disk Defines

        Distribution Disk descriptions used to prompt for the CD-ROMs
        during installation.

        One stanza per CDROM:

                num                     = the number on the CD-ROM's label
                name                    = the text string describing the CD-ROM
                diskid_filename         = the filename to search to identify the disk
                                          - supportsw shell wildcards.
                diskid_searchstring     = the string to search for in diskid_filename
                                          - supports perl regular expressions


=cut

#--------------------------------------------------------------------------------
{
    my $dd_ref = [
        {
         num  => '1',
         name => $::pkgdefs{DISTRO_NAME},

         diskid_searchargs => {
                               file => '.S.u.S.E-disk-001.2001082217',
                               key  => 'SuSE-Linux-SLES-i386 Version 7',
         },
         diskid_searchprog => \&Linux::linux_diskid_match_prog,
         diskid_target     => 'SLES7.2-i386',
        }
        ];

    $::pkgdefs{distro_disks} = $dd_ref;
}

#--------------------------------------------------------------------------------

=head3	opensrc_prereqs - Open Source Prereqs to Install

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $opr_ref;

    # defaults
    $opr_ref{$_server_}{$::csm_version} = [
                      'tftp-hpa', 'syslinux', 'IBMJava2-JRE-1.4.1', 'conserver',
                      'rdist',    'expect',   'fping'
                      ];
    $opr_ref{$_node_}{$::csm_version} =
      ['rdist', 'perl-libnet-1.07*', 'autoupdate'];

    # exceptions  - must follow the default assignments.
    $opr_ref{$_node_}{'1.2.0'} = ['rdist'];

    $::pkgdefs{opensrc_prereqs} = $opr_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	rsct_packages - RSCT Packages to Install

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $rp_ref;

    # defaults
    $rp_ref{$_server_}{$::csm_version} =
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic', 'rsct.core.cimrm'];
    $rp_ref{$_node_}{$::csm_version} =
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic', 'rsct.core.cimrm'];

    # exceptions  - must follow the default assignments.
    # none
    $rp_ref{$_node_}{'1.2.0'} = 
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic'];
    $rp_ref{$_node_}{'1.3.0'} = 
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic'];
    $rp_ref{$_node_}{'1.3.1'} = 
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic'];
    $rp_ref{$_node_}{'1.3.2'} = 
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic'];

    $::pkgdefs{rsct_packages} = $rp_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	csm_packages - CSM Packages to Install

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $cp_ref;

    # defaults
    $cp_ref{$_server_}{$::csm_version} =
      ['csm.core', 'csm.dsh', 'csm.server', 'csm.diagnostics', 'csm.gui.dcem'];
    $cp_ref{$_node_}{$::csm_version} =
      ['csm.core', 'csm.client', 'csm.diagnostics'];

    # exceptions  - must follow the default assignments.
    $cp_ref{$_node_}{'1.2.0'} = ['csm.core', 'csm.client'];

    $::pkgdefs{csm_packages} = $cp_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	director_packages - Director Packages to Install

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $dp_ref;

    # defaults
    $dp_ref{$_server_}{$::csm_version} =
      ['csm.director.agent', 'csm.director.server'];
    $dp_ref{$_node_}{$::csm_version} =
      ['csm.director.agent', 'csm.director.server'];

    # exceptions  - must follow the default assignments.
    $dp_ref{$_node_}{'1.2.0'} = [];
    $dp_ref{$_node_}{'1.3.0'} = [];

    $::pkgdefs{director_packages} = $dp_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	rsct_unpackages - RSCT Packages to uninstall

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $rup_ref;

    # defaults
    $rup_ref{$_server_}{$::csm_version} =
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.core.cimrm'];
    $rup_ref{$_node_}{$::csm_version} = 
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.core.cimrm'];

    # exceptions  - must follow the default assignments.
    # none
    $rup_ref{$_node_}{'1.2.0'} = 
      ['src', 'rsct.core.utils', 'rsct.core'];
    $rup_ref{$_node_}{'1.3.0'} = 
      ['src', 'rsct.core.utils', 'rsct.core'];
    $rup_ref{$_node_}{'1.3.1'} = 
      ['src', 'rsct.core.utils', 'rsct.core'];
    $rup_ref{$_node_}{'1.3.2'} = 
      ['src', 'rsct.core.utils', 'rsct.core'];

    $::pkgdefs{rsct_unpackages} = $rup_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	csm_unpackages - CSM Packages to uninstall	

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $cup_ref;

    # defaults
    $cup_ref{$_server_}{$::csm_version} =
      ['csm.dsh', 'csm.server', 'csm.diagnostics', 'csm.gui.dcem'];
    $cup_ref{$_node_}{$::csm_version} =
      ['csm.core', 'csm.diagnostics', 'csm.client'];

    # exceptions  - must follow the default assignments.
    $cup_ref{$_node_}{'1.2.0'} = ['csm.core', 'csm.client'];

    $::pkgdefs{csm_unpackages} = $cup_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	csm_uninstall_dirs - Directories to uninstall from the management server

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $cud_ref;

    # defaults
    $cud_ref{$_server_}{$::csm_version} = ['/csminstall', '/cfmroot'];
    $cud_ref{$_node_}{$::csm_version}   = [];

    # exceptions  - must follow the default assignments.
    # none

    $::pkgdefs{csm_uninstall_dirs} = $cud_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	csm_nouninstall_pkgs - Packages to NOT uninstall

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $cnip_ref;

    # defaults
    $cnip_ref{$_server_}{$::csm_version} = ['csm.core'];
    $cnip_ref{$_node_}{$::csm_version}   = [];

    # exceptions  - must follow the default assignments.
    # none

    $::pkgdefs{csm_nouninstall_pkgs} = $cnip_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	os_prereqs - Operating System pre-requisites

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $ospr_ref;

    $ospr_ref{$_server_} = [
                            'gppshare-*',  'perl-5*',
                            'nfs-utils-*', 'pdksh-*',
                            'dhcp-*',      'tcl-8*',
                            'tk-8*',       'xf86-*',
                            'freetype2-*', 'termcap-*',
                            'dosfstools-*'
                            ];
    $ospr_ref{$_node_} = [
                          'gppshare-*', 'perl-5*', 'nfs-utils-*', 'pdksh-*',
                          'dhcp-*',     'tcl-8*',  'tk-8*',       'xf86-*',
                          'freetype2-*'
                          ];

    $::pkgdefs{os_prereqs} = $ospr_ref{$::mgmt_type};
}

#--------------------------------------------------------------------------------

1;    # end
